const remote = require('electron').remote;
const Result = function(title) {
	this.title = title;
	this.html = document.createElement('li');
	this.window = remote.getCurrentWindow();
	this.html.addEventListener('dblclick', _ => {
		if(_.shiftKey)
			this.secondaryAction();
		else
			this.primaryAction();
	});
};
Result.prototype = {
	html: null,
	title: null,
	weight: 0,
	getHTML: function() {
		this.html.innerHTML = `<div class="title">${this.title}</div>` + (this.subtitle ? `<div class="subtitle">${this.subtitle}</div>` : '');
		return this.html;
	},
	destroy: function() {
		this.html.parentElement.removeChild(this.html);
	},
	primaryAction: function() {
		this.window.hide();
	},
	secondaryAction: function() {
		this.window.hide();
	},
	leftAction: function() {},
	rightAction: function() {},
	onselect: function() {},
	onunselect: function() {},
	onInteractionFinished: function() {}
};

module.exports = Result;