const Result = require('./Result.js');

const ImageResult = function(title, image) {
	Result.call(this, title);
	this.image = image;
}
ImageResult.prototype = Object.create(Result.prototype);

ImageResult.prototype.getHTML = function() {
	this.html.classList.add('image-result');
	this.html.style.backgroundImage = `url('${this.image}')`;
	// set height to match width in a 1:0.666 ratio
	this.html.style.minHeight = `${(document.body.clientWidth-20)*0.666}px`;
	const title = document.createElement('header');
	title.innerHTML = `<div class="title">${this.title}</div>` + (this.subtitle ? `<div class="subtitle">${this.subtitle}</div>` : '');
	this.html.appendChild(title);
	return this.html;
}

module.exports = ImageResult;